/*------------------------------------------------------------------------------*
 * File Name:GraphGetPts.h	 													*
 * Creation: CPY 6/2/2007														*
 * Purpose: OriginC Class for picking points from a graph						*
 * Copyright (c) Originlab Corp.	2007										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

class GetGraphPointsEx : public GetGraphPoints
{
public:
	GetGraphPointsEx(int nCursor, LPCSTR lpcszInitMsg = NULL, LPCSTR lpcszContinueMsg = NULL)
	{
		m_strInitMsg = lpcszInitMsg;
		m_strContinueFmt = lpcszContinueMsg;
		
		SetCursor(nCursor);
	}
	
	virtual void OnStart()
	{
		if(m_strInitMsg.IsEmpty())
			m_strInitMsg = "Move to the 1st point and double-click to select it";
		//SetDataDisplayText(m_strInitMsg);
		m_strMsg = m_strInitMsg;
		SetStatusBarText(m_strMsg);		
	}
	virtual void OnFinish()
	{
		//out_str("OnFinish");
	}
	virtual void OnNewPoint(int nPoint)
	{
		//SetDataDisplayText(strTemp);
		//out_int("OnNewPoint::", nPoint);
	}
	virtual void OnDisplay(string& str, int nPoint)
	{
		//printf("OnDisplay %d\n", nPoint);
		/// Hong 12/06/07 v8.0762 PFW_NEED_MORE_HINT_FOR_CURRENT_POINTS_IN_TOTAL
		GetGraphPoints::OnDisplay(str, nPoint);
		int nTotalPts = GetTotalPoints();
		/// end PFW_NEED_MORE_HINT_FOR_CURRENT_POINTS_IN_TOTAL
		if(nPoint < 0) // nPoint = 0,1,2, -1
		{
			str = _L("Finished");
			return;
		}
		string strFmt = m_strContinueFmt;
		/// Hong 12/06/07 v8.0762 PFW_NEED_MORE_HINT_FOR_CURRENT_POINTS_IN_TOTAL
		//if(strFmt.IsEmpty())			
			//strFmt = "%d: Double-click to get this point";
		//m_strMsg.Format(strFmt, nPoint+1); // use LT indexing for display
		if (strFmt.IsEmpty())
			//strFmt = "%d/%d: Double-click to get this point\r\n%s";
			strFmt = _L("%d/%d: Double-click to get this point\r\n%s");
		m_strMsg.Format(strFmt, nPoint+1, nTotalPts, str); // use LT indexing for display
		/// end PFW_NEED_MORE_HINT_FOR_CURRENT_POINTS_IN_TOTAL
		SetStatusBarText(m_strMsg);
		str = m_strMsg;
	}
	virtual void OnCancel()
	{
		//out_str("OnCancel");
	}
private:
	string m_strInitMsg;
	string m_strContinueFmt;
	string m_strMsg;
};
